<?php
require __DIR__ . '/../bootstrap.php';

use Core\Auth;
use Core\DB;
use Services\TwitterClient;

Auth::requireRole(['admin','editor']);

$active = 'twitter_sources';
$testResult = null;

if (isset($_GET['test_id'])) {
    $id = (int)$_GET['test_id'];
    $rowStmt = DB::query("
        SELECT ts.*, sa.name AS account_name, sa.api_key AS bearer_token
        FROM twitter_sources ts
        INNER JOIN social_accounts sa ON sa.id = ts.social_account_id
        WHERE ts.id = :id
        LIMIT 1
    ", ['id' => $id]);
    $src = $rowStmt->fetch();
    if ($src) {
        try {
            if (empty($src['bearer_token'])) {
                throw new \Exception('لا يوجد Bearer Token مضبوط لهذا الحساب.');
            }
            $client = new TwitterClient($src['bearer_token']);
            $includeRetweets = (int)$src['include_retweets'] === 1;
            $includeReplies = (int)$src['include_replies'] === 1;
            $data = $client->fetchUserTweets($src['identifier'], null, 1, $includeRetweets, $includeReplies);
            if (!empty($data['data'][0])) {
                $t = $data['data'][0];
                $testResult = [
                    'ok' => true,
                    'message' => 'تم جلب آخر تغريدة بنجاح',
                    'tweet' => $t,
                    'url' => 'https://x.com/' . $src['identifier'] . '/status/' . $t['id']
                ];
            } else {
                $testResult = ['ok' => false, 'message' => 'لم يتم العثور على تغريدات لهذا الحساب بالفلتر الحالي.'];
            }
        } catch (Throwable $e) {
            $testResult = ['ok' => false, 'message' => 'خطأ أثناء الاتصال بتويتر: ' . $e->getMessage()];
        }
    } else {
        $testResult = ['ok' => false, 'message' => 'المصدر غير موجود.'];
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_GET['test_id'])) {
    $social_account_id = (int)($_POST['social_account_id'] ?? 0);
    $identifier = trim($_POST['identifier'] ?? '');
    $display_name = trim($_POST['display_name'] ?? '');
    $source_type = 'user';
    $include_retweets = isset($_POST['include_retweets']) ? 1 : 0;
    $include_replies = isset($_POST['include_replies']) ? 1 : 0;

    DB::query('INSERT INTO twitter_sources (social_account_id, source_type, identifier, display_name, include_retweets, include_replies, status, created_at, updated_at)
        VALUES (:sid, :st, :idn, :dn, :ir, :ip, "active", NOW(), NOW())', [
        'sid' => $social_account_id,
        'st' => $source_type,
        'idn' => $identifier,
        'dn' => $display_name,
        'ir' => $include_retweets,
        'ip' => $include_replies,
    ]);

    header('Location: twitter_sources.php');
    exit;
}

$accounts = DB::query("SELECT * FROM social_accounts WHERE platform = 'twitter' ORDER BY name")->fetchAll();
$sources = DB::query("
    SELECT ts.*, sa.name AS account_name
    FROM twitter_sources ts
    INNER JOIN social_accounts sa ON sa.id = ts.social_account_id
    ORDER BY ts.id DESC
")->fetchAll();

include __DIR__ . '/_layout_header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>مصادر تويتر</h3>
</div>

<?php if($testResult): ?>
  <div class="alert <?= $testResult['ok'] ? 'alert-success' : 'alert-danger' ?>">
    <?= htmlspecialchars($testResult['message']) ?>
    <?php if($testResult['ok'] && !empty($testResult['tweet'])): ?>
      <hr>
      <div><strong>نص التغريدة:</strong></div>
      <div class="mb-2"><?= nl2br(htmlspecialchars($testResult['tweet']['text'])) ?></div>
      <a href="<?= htmlspecialchars($testResult['url']) ?>" target="_blank" class="btn btn-sm btn-outline-light">عرض على تويتر</a>
    <?php endif; ?>
  </div>
<?php endif; ?>

<div class="card mb-4">
  <div class="card-header">إضافة مصدر (حساب تويتر)</div>
  <div class="card-body">
    <form method="post">
      <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">حساب Twitter API</label>
          <select name="social_account_id" class="form-select" required>
            <option value="">اختر...</option>
            <?php foreach ($accounts as $a): ?>
              <option value="<?= $a['id'] ?>"><?= htmlspecialchars($a['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-4">
          <label class="form-label">اسم المستخدم في تويتر (بدون @)</label>
          <input type="text" name="identifier" class="form-control" placeholder="lenspost" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">اسم تعريفي للمصدر</label>
          <input type="text" name="display_name" class="form-control" placeholder="حساب العدسة بوست" required>
        </div>
        <div class="col-md-4">
          <div class="form-check mt-4">
            <input class="form-check-input" type="checkbox" name="include_retweets" id="include_retweets">
            <label class="form-check-label" for="include_retweets">
              تضمين الـ Retweets
            </label>
          </div>
        </div>
        <div class="col-md-4">
          <div class="form-check mt-4">
            <input class="form-check-input" type="checkbox" name="include_replies" id="include_replies">
            <label class="form-check-label" for="include_replies">
              تضمين الـ Replies
            </label>
          </div>
        </div>
      </div>
      <button class="btn btn-primary mt-3">حفظ</button>
    </form>
  </div>
</div>

<div class="card">
  <div class="card-header">القائمة</div>
  <div class="card-body p-0">
    <table class="table table-striped table-sm mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>حساب Twitter API</th>
          <th>المعرف</th>
          <th>الاسم</th>
          <th>أخر Tweet ID</th>
          <th>Retweets</th>
          <th>Replies</th>
          <th>الحالة</th>
          <th>اختبار</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($sources as $s): ?>
        <tr>
          <td><?= $s['id'] ?></td>
          <td><?= htmlspecialchars($s['account_name']) ?></td>
          <td>@<?= htmlspecialchars($s['identifier']) ?></td>
          <td><?= htmlspecialchars($s['display_name']) ?></td>
          <td><?= htmlspecialchars($s['last_tweet_id']) ?></td>
          <td><?= $s['include_retweets'] ? 'نعم' : 'لا' ?></td>
          <td><?= $s['include_replies'] ? 'نعم' : 'لا' ?></td>
          <td><?= htmlspecialchars($s['status']) ?></td>
          <td>
            <a href="twitter_sources.php?test_id=<?= $s['id'] ?>" class="btn btn-sm btn-outline-primary">Test Fetch</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/_layout_footer.php'; ?>
