<?php
require __DIR__ . '/../bootstrap.php';

use Core\Auth;
use Core\DB;
use Services\TelegramClient;

Auth::requireRole(['admin','editor']);

$active = 'telegram_targets';
$testResult = null;

if (isset($_GET['test_id'])) {
    $id = (int)$_GET['test_id'];
    $rowStmt = DB::query("
        SELECT tt.*, sa.bot_token, sa.name AS bot_name
        FROM telegram_targets tt
        INNER JOIN social_accounts sa ON sa.id = tt.social_account_id
        WHERE tt.id = :id
        LIMIT 1
    ", ['id' => $id]);
    $target = $rowStmt->fetch();
    if ($target) {
        try {
            if (empty($target['bot_token'])) {
                throw new \Exception('Bot Token غير مضبوط للبوت المرتبط.');
            }
            $bot = new TelegramClient($target['bot_token']);
            $msg = "🔔 Test message from Twitter→Telegram sync panel";
            $res = $bot->sendMessage($target['chat_id'], $msg);
            if (!empty($res['ok'])) {
                $testResult = ['ok' => true, 'message' => 'تم إرسال رسالة اختبار بنجاح إلى الوجهة المحددة.'];
            } else {
                $testResult = ['ok' => false, 'message' => 'فشل في إرسال الرسالة. تحقق من صلاحيات البوت و Chat ID.'];
            }
        } catch (Throwable $e) {
            $testResult = ['ok' => false, 'message' => 'خطأ أثناء الاتصال بتليجرام: ' . $e->getMessage()];
        }
    } else {
        $testResult = ['ok' => false, 'message' => 'الوجهة غير موجودة.'];
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_GET['test_id'])) {
    $social_account_id = (int)($_POST['social_account_id'] ?? 0);
    $chat_id = trim($_POST['chat_id'] ?? '');
    $display_name = trim($_POST['display_name'] ?? '');
    $target_type = $_POST['target_type'] ?? 'channel';

    DB::query('INSERT INTO telegram_targets (social_account_id, target_type, chat_id, display_name, status, created_at, updated_at)
        VALUES (:sid, :tt, :cid, :dn, "active", NOW(), NOW())', [
        'sid' => $social_account_id,
        'tt' => $target_type,
        'cid' => $chat_id,
        'dn' => $display_name,
    ]);

    header('Location: telegram_targets.php');
    exit;
}

$bots = DB::query("SELECT * FROM social_accounts WHERE platform = 'telegram' ORDER BY name")->fetchAll();
$targets = DB::query("
    SELECT tt.*, sa.name AS bot_name
    FROM telegram_targets tt
    INNER JOIN social_accounts sa ON sa.id = tt.social_account_id
    ORDER BY tt.id DESC
")->fetchAll();

include __DIR__ . '/_layout_header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>قنوات / وجهات تليجرام</h3>
</div>

<?php if($testResult): ?>
  <div class="alert <?= $testResult['ok'] ? 'alert-success' : 'alert-danger' ?>">
    <?= htmlspecialchars($testResult['message']) ?>
  </div>
<?php endif; ?>

<div class="card mb-4">
  <div class="card-header">إضافة وجهة نشر</div>
  <div class="card-body">
    <form method="post">
      <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">بوت تليجرام</label>
          <select name="social_account_id" class="form-select" required>
            <option value="">اختر...</option>
            <?php foreach ($bots as $b): ?>
              <option value="<?= $b['id'] ?>"><?= htmlspecialchars($b['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-4">
          <label class="form-label">Chat ID / @username</label>
          <input type="text" name="chat_id" class="form-control" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">نوع الوجهة</label>
          <select name="target_type" class="form-select">
            <option value="channel">Channel</option>
            <option value="group">Group</option>
            <option value="user">User</option>
          </select>
        </div>
        <div class="col-md-6">
          <label class="form-label">اسم تعريفي</label>
          <input type="text" name="display_name" class="form-control" required>
        </div>
      </div>
      <button class="btn btn-primary mt-3">حفظ</button>
    </form>
  </div>
</div>

<div class="card">
  <div class="card-header">القائمة</div>
  <div class="card-body p-0">
    <table class="table table-striped table-sm mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>البوت</th>
          <th>Chat ID</th>
          <th>الاسم</th>
          <th>النوع</th>
          <th>الحالة</th>
          <th>اختبار</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($targets as $t): ?>
        <tr>
          <td><?= $t['id'] ?></td>
          <td><?= htmlspecialchars($t['bot_name']) ?></td>
          <td><?= htmlspecialchars($t['chat_id']) ?></td>
          <td><?= htmlspecialchars($t['display_name']) ?></td>
          <td><?= htmlspecialchars($t['target_type']) ?></td>
          <td><?= htmlspecialchars($t['status']) ?></td>
          <td>
            <a href="telegram_targets.php?test_id=<?= $t['id'] ?>" class="btn btn-sm btn-outline-primary">Test Send</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/_layout_footer.php'; ?>
