<?php
require __DIR__ . '/../bootstrap.php';

use Core\Auth;
use Core\DB;

Auth::requireRole(['admin']);

$active = 'users';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $role = $_POST['role'] ?? 'editor';

    if ($name && $email && $password) {
        $hash = password_hash($password, PASSWORD_BCRYPT);
        DB::query('INSERT INTO users (name, email, password, role, created_at, updated_at)
            VALUES (:n, :e, :p, :r, NOW(), NOW())', [
            'n' => $name,
            'e' => $email,
            'p' => $hash,
            'r' => $role,
        ]);
        header('Location: users.php');
        exit;
    }
}

$users = DB::query("SELECT * FROM users ORDER BY id DESC")->fetchAll();

include __DIR__ . '/_layout_header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>المستخدمون</h3>
</div>

<div class="card mb-4">
  <div class="card-header">إضافة مستخدم جديد</div>
  <div class="card-body">
    <form method="post">
      <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">الاسم</label>
          <input type="text" name="name" class="form-control" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">البريد الإلكتروني</label>
          <input type="email" name="email" class="form-control" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">كلمة المرور</label>
          <input type="text" name="password" class="form-control" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">الدور</label>
          <select name="role" class="form-select">
            <option value="admin">Admin</option>
            <option value="editor" selected>Editor</option>
            <option value="viewer">Viewer</option>
          </select>
        </div>
      </div>
      <button class="btn btn-primary mt-3">حفظ</button>
    </form>
  </div>
</div>

<div class="card">
  <div class="card-header">القائمة</div>
  <div class="card-body p-0">
    <table class="table table-striped table-sm mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>الاسم</th>
          <th>البريد</th>
          <th>الدور</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($users as $u): ?>
        <tr>
          <td><?= $u['id'] ?></td>
          <td><?= htmlspecialchars($u['name']) ?></td>
          <td><?= htmlspecialchars($u['email']) ?></td>
          <td><?= htmlspecialchars($u['role']) ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/_layout_footer.php'; ?>
