<?php
require __DIR__ . '/../bootstrap.php';

use Core\Auth;
use Core\DB;

Auth::requireRole(['admin','editor']);

$active = 'logs';

$statusFilter = $_GET['status'] ?? '';
$limit = 100;

$sql = "
    SELECT pl.*, p.tweet_url, ts.display_name AS source_name, tt.display_name AS target_name
    FROM post_logs pl
    INNER JOIN posts p ON p.id = pl.post_id
    INNER JOIN publishing_rules pr ON pr.id = pl.publishing_rule_id
    INNER JOIN twitter_sources ts ON ts.id = pr.twitter_source_id
    INNER JOIN telegram_targets tt ON tt.id = pr.telegram_target_id
";
$params = [];
if ($statusFilter === 'success' || $statusFilter === 'failed') {
    $sql .= " WHERE pl.status = :st";
    $params['st'] = $statusFilter;
}
$sql .= " ORDER BY pl.id DESC LIMIT " . (int)$limit;

$logs = DB::query($sql, $params)->fetchAll();

include __DIR__ . '/_layout_header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>سجلات النشر</h3>
</div>

<div class="card mb-3">
  <div class="card-body">
    <form class="row g-3">
      <div class="col-md-3">
        <label class="form-label">حالة الفلترة</label>
        <select name="status" class="form-select" onchange="this.form.submit()">
          <option value="">الكل</option>
          <option value="success" <?= $statusFilter === 'success' ? 'selected' : '' ?>>نجاح</option>
          <option value="failed" <?= $statusFilter === 'failed' ? 'selected' : '' ?>>فشل</option>
        </select>
      </div>
      <div class="col-md-3 d-flex align-items-end">
        <span class="text-muted small">يتم عرض آخر <?= $limit ?> سجل.</span>
      </div>
    </form>
  </div>
</div>

<div class="card">
  <div class="card-header">آخر السجلات</div>
  <div class="card-body p-0">
    <table class="table table-striped table-sm mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>المصدر</th>
          <th>الوجهة</th>
          <th>الحالة</th>
          <th>رسالة الخطأ</th>
          <th>نص المرسل</th>
          <th>رابط التغريدة</th>
          <th>التاريخ</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($logs as $l): ?>
        <tr>
          <td><?= $l['id'] ?></td>
          <td><?= htmlspecialchars($l['source_name']) ?></td>
          <td><?= htmlspecialchars($l['target_name']) ?></td>
          <td>
            <?php if ($l['status'] === 'success'): ?>
              <span class="badge bg-success">نجاح</span>
            <?php else: ?>
              <span class="badge bg-danger">فشل</span>
            <?php endif; ?>
          </td>
          <td style="max-width:200px;"><?= nl2br(htmlspecialchars(mb_strimwidth($l['error_message'] ?? '', 0, 200, '...'))) ?></td>
          <td style="max-width:250px;"><?= nl2br(htmlspecialchars(mb_strimwidth($l['sent_text'] ?? '', 0, 250, '...'))) ?></td>
          <td><a href="<?= htmlspecialchars($l['tweet_url']) ?>" target="_blank">التغريدة</a></td>
          <td><?= htmlspecialchars($l['created_at']) ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/_layout_footer.php'; ?>
