<?php
use Core\Auth;
$config = require __DIR__ . '/../config/config.php';
$baseUrl = $config['app']['base_url'];
$user = Auth::user();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>Social Sync Panel</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background-color: #f4f6f9; }
    .sidebar { min-height: 100vh; background: #111827; color: #fff; }
    .sidebar a { color: #e5e7eb; text-decoration: none; display:block; padding: .5rem 1rem; border-radius: .5rem; }
    .sidebar a.active, .sidebar a:hover { background: #1f2937; color: #fff; }
    .content { padding: 1.5rem; }
    .table-sm td, .table-sm th { padding: .3rem .4rem; }
  </style>
</head>
<body>
<div class="container-fluid">
  <div class="row">
    <nav class="col-md-2 d-none d-md-block sidebar py-3">
      <div class="px-3 mb-4">
        <h5 class="fw-bold">Twitter → Telegram</h5>
        <?php if($user): ?>
          <div class="small text-muted mb-2">
            مرحبًا، <?= htmlspecialchars($user['name']) ?> (<?= htmlspecialchars($user['role']) ?>)
          </div>
        <?php endif; ?>
      </div>
      <ul class="nav flex-column px-2">
        <li class="nav-item"><a class="nav-link <?= ($active ?? '') === 'dashboard' ? 'active' : '' ?>" href="<?= $baseUrl ?>/index.php">لوحة التحكم</a></li>
        <li class="nav-item"><a class="nav-link <?= ($active ?? '') === 'twitter_accounts' ? 'active' : '' ?>" href="<?= $baseUrl ?>/twitter_accounts.php">حسابات تويتر (API)</a></li>
        <li class="nav-item"><a class="nav-link <?= ($active ?? '') === 'twitter_sources' ? 'active' : '' ?>" href="<?= $baseUrl ?>/twitter_sources.php">مصادر تويتر</a></li>
        <li class="nav-item"><a class="nav-link <?= ($active ?? '') === 'telegram_bots' ? 'active' : '' ?>" href="<?= $baseUrl ?>/telegram_bots.php">بوتات تليجرام</a></li>
        <li class="nav-item"><a class="nav-link <?= ($active ?? '') === 'telegram_targets' ? 'active' : '' ?>" href="<?= $baseUrl ?>/telegram_targets.php">قنوات تليجرام</a></li>
        <li class="nav-item"><a class="nav-link <?= ($active ?? '') === 'rules' ? 'active' : '' ?>" href="<?= $baseUrl ?>/rules.php">قواعد النشر</a></li>
        <li class="nav-item"><a class="nav-link <?= ($active ?? '') === 'logs' ? 'active' : '' ?>" href="<?= $baseUrl ?>/logs.php">سجلات النشر</a></li>
        <li class="nav-item"><a class="nav-link <?= ($active ?? '') === 'users' ? 'active' : '' ?>" href="<?= $baseUrl ?>/users.php">المستخدمون</a></li>
        <li class="nav-item mt-3"><a class="nav-link" href="<?= $baseUrl ?>/logout.php">تسجيل الخروج</a></li>
      </ul>
    </nav>
    <main class="col-md-10 ms-sm-auto col-lg-10 content">
