<?php
session_start();

$config = require __DIR__ . '/config/config.php';

// Autoload classes from src
spl_autoload_register(function ($class) {
    $baseDir = __DIR__ . '/src/';
    $file = $baseDir . str_replace('\\', '/', $class) . '.php';
    if (file_exists($file)) {
        require $file;
    }
});

use Core\DB;
use Core\Auth;

DB::init($config['db']);
Auth::init($config['app']['session_name']);
