<?php
namespace App\Storage;

use App\Http\HttpClient;

class ImageDownloader
{
    public function __construct(private HttpClient $http, private string $imagesDir) {}

    public function downloadProductImages(int $productId, array $imageUrls): array
    {
        $productDir = rtrim($this->imagesDir, '/')."/{$productId}";
        if (!is_dir($productDir)) mkdir($productDir, 0775, true);

        $local = [];
        $i = 1;
        foreach ($imageUrls as $url) {
            $ext = $this->guessExt($url);
            $filename = str_pad((string)$i, 2, '0', STR_PAD_LEFT) . '.' . $ext;
            $dest = $productDir . '/' . $filename;
            if (!file_exists($dest)) {
                $this->http->download($url, $dest);
            }
            $local[] = ['url' => $url, 'path' => $dest];
            $i++;
        }
        return $local;
    }

    private function guessExt(string $url): string
    {
        $path = parse_url($url, PHP_URL_PATH) ?: '';
        $ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg','jpeg','png','webp','gif'], true)) {
            return $ext === 'jpeg' ? 'jpg' : $ext;
        }
        return 'jpg';
    }
}
