<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <title>نظام إدارة المصروفات</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap من CDN -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css">
    <!-- أيقونات -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
    <style>
        body {
            background-color: #f5f6fa;
        }
        .navbar-brand {
            font-weight: bold;
        }
        .sidebar {
            min-height: 100vh;
            background: #1f2933;
            color: #fff;
        }
        .sidebar a {
            color: #cbd2d9;
            text-decoration: none;
            display: block;
            padding: 10px 15px;
        }
        .sidebar a.active, .sidebar a:hover {
            background: #111827;
            color: #fff;
        }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom shadow-sm">
  <div class="container-fluid">
    <a class="navbar-brand" href="index.php">نظام المصروفات</a>
    <div class="d-flex align-items-center">
      <?php if (!empty($_SESSION['user_name'])): ?>
        <span class="me-3">مرحبًا، <?= htmlspecialchars($_SESSION['user_name']) ?></span>
        <a href="logout.php" class="btn btn-outline-danger btn-sm">تسجيل الخروج</a>
      <?php endif; ?>
    </div>
  </div>
</nav>

<div class="container-fluid">
  <div class="row">
    <?php if (!empty($_SESSION['user_id'])): ?>
    <aside class="col-md-3 col-lg-2 sidebar p-0">
      <div class="p-3">
        <h6 class="text-uppercase text-muted">القائمة</h6>
      </div>
      <a href="index.php"><i class="fa fa-gauge"></i> لوحة التحكم</a>
      <a href="upload.php"><i class="fa fa-file-arrow-up"></i> رفع ملف Excel</a>
      <a href="files.php"><i class="fa fa-folder-open"></i> الملفات المرفوعة</a>
      <a href="reports.php"><i class="fa fa-chart-line"></i> التقارير والتحليلات</a>
      <a href="logs.php"><i class="fa fa-list"></i> سجل النشاطات</a>
      <?php if (!empty($_SESSION['role_name']) && $_SESSION['role_name'] === 'admin'): ?>
        <!-- مساحة مستقبلية لإدارة المستخدمين -->
      <?php endif; ?>
    </aside>
    <main class="col-md-9 col-lg-10 p-4">
    <?php else: ?>
    <main class="col-12 p-4">
    <?php endif; ?>
